# **SUD_Egyptian-UJaen**: SUD treebank conversion for the corpus UD_Egyptian-UJaen version 2.17
This treebank was automatically generated from the UD treebank:
[UD_Egyptian-UJaen](https://github.com/UniversalDependencies/UD_Egyptian-UJaen/releases/tag/r2.17).

See [SUD data page](https://surfacesyntacticud.org/data/) for more details about the conversion process.

The rest of this file is a copy of the original README associated to **UD_Egyptian-UJaen** and therefore refers to UD.

---
---

# Summary

Egyptian-UJaen is the first dependency treebank created for the morphosyntactic annotation of pre-Coptic Egyptian. Its current state (UD v2.17) consists of 2,347 sentences and 24,375 tokens manually annotated from texts written in Old Egyptian, mainly from the Pyramid Texts.


# Introduction

The Egyptian-UJaen treebank (henceforth EUJA treebank) contains a corpus of Egyptian texts manually annotated at the University of Jaén following the Tübingen transcription system (see below). It aims to contribute to the Universal Dependencies (UD) project and to the PARSEME corpora of multiword expressions in order to compare Egyptian morphosyntactic features with those from other languages. The EUJA treebank started as UD release 2.14 with 5,515 words and 707 sentences. It contained Old Egyptian multiword expressions and sentences from the Pyramid Texts (see list of sources, below). The systematic annotation of the Pyramid Texts begins with EUJA-44. Unas's Pyramid Texts were annotated in the EUJA treebank for the UD release 2.15, and Teti's Pyramid Texts for the UD release 2.16. Annotation of Pepi I's Pyramid Texts began for the UD release 2.17. Data exploration in these texts can be carried out using [GrewPT](https://grew.fr/grew_match/pt/)

The treebank will contain texts from various historical stages: Old Egyptian, Middle Egyptian, Late Egyptian
and Demotic. For an overall description of these linguistic stages, see the [Language Page for
Egyptian](https://universaldependencies.org/egy/index.html); and the bibliography below.

# Further Details

Tübingen Transcription System

<table>
<tr><th>Egypt</th>	<th>Schenkel</th></tr>
<tr><td>𓄿</td>	<td>ꜣ</td></tr>
<tr><td>𓇋</td>	<td>ꞽ</td></tr>
<tr><td>𓇌</td>	<td>y</td></tr>
<tr><td>𓏭</td>	<td>ï</td></tr>
<tr><td>𓂝</td>	<td>ꜥ</td></tr>
<tr><td>𓅱</td>	<td>w</td></tr>
<tr><td>𓃀</td>	<td>b</td></tr>
<tr><td>𓊪</td>	<td>p</td></tr>
<tr><td>𓆑</td>	<td>f</td></tr>
<tr><td>𓅓</td>	<td>m</td></tr>
<tr><td>𓈖</td>	<td>n</td></tr>
<tr><td>𓂋</td>	<td>r</td></tr>
<tr><td>𓉔</td>	<td>h</td></tr>
<tr><td>𓎛</td>	<td>ḥ</td></tr>
<tr><td>𓐍</td>	<td>ḫ</td></tr>
<tr><td>𓄡</td>	<td>ẖ</td></tr>
<tr><td>𓊃</td>	<td>s</td></tr>
<tr><td>𓋴</td>	<td>ś</td></tr>
<tr><td>𓈙</td>	<td>š</td></tr>
<tr><td>𓈎</td>	<td>ḳ</td></tr>
<tr><td>𓎡</td>	<td>k</td></tr>
<tr><td>𓎼</td>	<td>g</td></tr>
<tr><td>𓏏</td>	<td>t</td></tr>
<tr><td>𓍿</td>	<td>č</td></tr>
<tr><td>𓂧</td>	<td>ṭ</td></tr>
<tr><td>𓆓</td>	<td>č̣</td></tr>
</table>


# Acknowledgments

This work received support from the CA21167 COST action UniDive, funded by COST (European Cooperation in Science and Technology). I thank Agata Savary (UniDive/PARSEME), Daniel Zeman (UniDive/UD) and Marco Carlo Passarotti (CIRCSE) for introducing me to computational linguistics.

# Publications related to the project

- Díaz Hernández, Roberto Antonio and Passarotti, Marco Carlo. 2024. "Developing the Egyptian-UJaen Treebank". In D. Dakota et al. (eds.) Proceedings of the 22nd Workshop on Treebanks and Linguistic Theories (TLT 2024) Association for Computational Linguistics, pages 1–10. https://aclanthology.org/2024.tlt-1.1/
- Díaz Hernández, Roberto Antonio. 2025. "A Typology of Non-Projective Patterns in Unas’s and Teti’s Pyramid Texts". In E. Hajičová, S. Kahane (eds.) Proceedings of the Eighth International Conference on Dependency Linguistics (Depling, SyntaxFest 2025), pages 1-12. https://aclanthology.org/2025.depling-1.1/
- Díaz Hernández, Roberto Antonio and Zeman, Daniel 2025. "Annotation of Relative Forms in the Egyptian-UJaen Treebank". In G. Bouma, Ç. Çöltekin (eds.) Proceedings of the Eighth Workshop on Universal Dependencies (UDW, SyntaxFest 2025), pages 11-21. https://aclanthology.org/2025.udw-1.2/.

# Bibliography used for the Language Page

- Černý, Jaroslav/Groll, Israelit. 1975. A Late Egyptian Grammar, Rome.
- Díaz Hernández, Roberto A. 2021. “The Man-impersonal śč̣m.n-ti҆/tw(⸗f) Form in Earlier Egyptian”, LingAeg 29, 37–59.
- Díaz Hernández, Roberto A. 2022. “The Man-impersonal Verb Forms of the Suffix Pronoun Conjugation in Earlier Egyptian”, LingAeg 30, 25–90.
- Edel, Elmar. 1955/1964. Altägyptische Grammatik, Rome.
- Erman, Adolf. 1933. Neuägyptische Grammatik, Leipzig.
- Fischer-Elfert, Hans-W. 2021. Grundzüge einer Geschichte des Hieratischen (2 vols.), Berlin.
- Gardiner, Alan H. 1957. Egyptian Grammar. Being an Introduction to the Study of Hieroglyphs,
Oxford.
- Johnson, Janet H. 2000. Thus Wrote ꜥOnchsheshonqy. An Introductory Grammar of Demotic, Chicago.
- Junge, Friedrich. 2008. Neuägyptisch. Einführung in die Grammatik, Wiesbaden.
- Satzinger, Helmut. 2021. ‘Is there not one among you who understands Egyptian?’ The Late Egyptian Language: - Structure of its Grammar, London.
- Schenkel, Wolfgang. 2012. Tübinger Einführung in die klassisch-ägyptische Sprache und Schrift, Tübingen.
- Spiegelberg, Wilhelm. 19752. Demotische Grammatik, Heidelberg.


# Sources for the treebank

- Allen, James P. 2013. A New Concordance of the Pyramid Texts (6 vols.), Brown University.
- Borchardt, Ludwig. 1907. Das Grabdenkmal des Königs Ne-user-reʿ, Leipzig.
- Borchardt, Ludwig. 1911. Catalogue général des antiquités égyptiennes du Musée du Caire. Statuen und Statuetten von Königen und Privatleuten, Berlin.
- Borchardt, Ludwig. 1937–1964. Catalogue général des antiquités égyptiennes du Musée du Caire. Denkmäler des Alten Reiches, Cairo.
- Clère, J. J. and Vandier, J. 1948. Textes de la Première Période Intermédiaire et de la XIème Dynastie, Bibliotheca Aegyptiaca X, Bruxelles.
- Davies, Norman de Garis. 1900. The Mastaba of Ptahhetep and Akhethetep at Saqqarah, London.
- Duell, Prentice. 1938. The Mastaba of Mereruka, Part II, Chicago.
- Edel, Elmar (Seyfried, Karl-J./Vieler, Gerd, eds.) 2008. Die Felsgräbernekropole der Qubbet el-Hawa bei Assuan, Paderborn, Munich, Vienna, Zürich.
- Gardiner, Alan H. and Sethe, Kurt. 1928. Egyptian Letters to the Dead mainly from the Old and Middle Kingdoms, London.
- Griffith, Francis L. 1889. The Inscriptions of Siûṭ and Dêr Rifeh, London.
- James, Thomas G. H. 1953. The Mastaba of Khentika called Ikhekhi, London.
- Kanawati, Naguib. 1987. The Rock Tombs of el-Hawawish. The Cemetery of Akhmim. Volume VII, Sydney.
- Lange, Hans O. and Schäfer, Heinrich. 1902–1925. Catalogue général des antiquités égyptiennes du Musée du Caire. Grab- und Denksteine des Mittleren Reichs (4 vols.), Berlin.
- Mariette, Auguste. 1889. Les mastabas de l’ancien empire, Paris.
- Sethe, Kurt. 1908–1922. Die altägyptischen Pyramidentexte nach den Papierabdrücken und Photographien des Berliner Museums (4 vols.), Leipzig.
- Sethe, Kurt. 1933. Urkunden des Alten Reichs, Leipzig.


# Digital resources for Egyptian

- [GrewPT](https://grew.fr/grew_match/about/)
- [Ramses Online](http://ramses.ulg.ac.be/)
- [Thesaurus Linguae Aegyptiae](https://thesaurus-linguae-aegyptiae.de/home)

# Changelog

* 2024-05-15 v2.14
  * Initial release in Universal Dependencies.


<pre>
=== Machine-readable metadata (DO NOT REMOVE!) ================================
Data available since: UD v2.14
License: CC BY-SA 4.0
Includes text: yes
Parallel: no
Genre: bible fiction nonfiction government
Lemmas: manual native
UPOS: manual native
XPOS: not available
Features: manual native
Relations: manual native
Contributors: Díaz Hernández, Roberto Antonio; Guillaume, Bruno; Zeman, Daniel
Contributing: here
Contact: radiaz@ujaen.es
===============================================================================
</pre>
