# pSUD_Naija-NSC

This treebank is the prosody based version of the corresponding [SUD_Naija-NSC](https://github.com/surfacesyntacticud/SUD_Naija-NSC).
It contains both the syntactic structure and the syllables encoding.

## Reference
 - Emmett Strickland, Anne Lacheret-Dujour, Sylvain Kahane, Marc Evrard, Perrine Quennehen, Bernard Caron, Francis Egbokhare, and Bruno Guillaume. 2024. [New Methods for Exploring Intonosyntax: Introducing an Intonosyntactic Treebank for Nigerian Pidgin](https://aclanthology.org/2024.lrec-main.1068/). In Proceedings of the 2024 Joint International Conference on Computational Linguistics, Language Resources and Evaluation (LREC-COLING 2024), pages 12207–12216, Torino, Italia. ELRA and ICCL.

## Syllables encoding

The empty node mechanism borrowed from enhanced UD encoding is used to represent each syllable.
Special links (labelled `Syl=1`, `Syl=2`, etc) are used to encode the relationship between tokens and syllables.

Below and example of the encoding of the Naija sentence _you understand ?_

```
# sent_id = ENU_22_Barman-Interview_MG__53
# text = # you understand ?//
# text_en = You understand?
# text_ortho = You understand?
1	#	#	PUNCT	_	_	3	punct	_	AlignBegin=200000|AlignEnd=200330|Gloss=PUNCT
2	you	you	PRON	_	Case=Nom|Person=2|PronType=Prs	3	subj	_	AlignBegin=200330|AlignEnd=200400|Gloss=NOM.2|phoneticform=jO
2.1	_	_	_	_	_	2|3	Syl=1|Syl=1	_	AlignBegin=200330|AlignEnd=200467|AvgAmplitude=66.875|AvgAmplitudeGlobalZscore=1.1|AvgAmplitudeLocalZscore=1|AvgAmplitudeNormalized=1|AvgHeightGlo=M|AvgHeightLoc=M|Coda=None|Duration=137|DurationGlobalZscore=-0.65|DurationLocalZscore=-1|DurationNormalized=0|Glo=mm|Loc=mm|MaxAmplitude=69.071|MaxAmplitudeGlobalZscore=-0.701|MaxAmplitudeLocalZscore=-1|MaxAmplitudeNormalized=0|MeanF0=89.768|MeanF0GlobalZscore=1.528|MeanF0LocalZscore=0.604|MeanF0Normalized=0.909|Nucleus=O|Onset=j|PitchRangeGlo=L|PitchRangeLoc=L|SemitonesFromUtteranceMean=-0.897|Slope=Flat|SlopeGlo=Flat|SlopeLoc=Flat|StepsFromLeft=1|StepsFromRight=1|SylForm=jO
3	understand	understand	VERB	_	_	0	root	_	AlignBegin=200400|AlignEnd=200841|Gloss=understand|phoneticform=FUSEDsta~|UtteranceMeanF0=96.185
3.1	_	_	_	_	_	3	Syl=2	_	AlignBegin=200467|AlignEnd=200841|AvgAmplitude=66.006|AvgAmplitudeGlobalZscore=-1.217|AvgAmplitudeLocalZscore=-1|AvgAmplitudeNormalized=0|AvgHeightGlo=M|AvgHeightLoc=M|Coda=None|Duration=373|DurationGlobalZscore=-0.307|DurationLocalZscore=1|DurationNormalized=1|Glo=mm|Loc=mm|MaxAmplitude=69.853|MaxAmplitudeGlobalZscore=0.675|MaxAmplitudeLocalZscore=1|MaxAmplitudeNormalized=1|MeanF0=0|MeanF0GlobalZscore=-1.034|MeanF0LocalZscore=-1.409|MeanF0Normalized=0|Nucleus=a~|Onset=st|PitchRangeGlo=L|PitchRangeLoc=L|SemitonesFromUtteranceMean=0|Slope=X|SlopeGlo=Flat|SlopeLoc=Flat|StepsFromLeft=2|StepsFromRight=1|SylForm=sta~
4	?//	?//	PUNCT	_	_	3	punct	_	AlignBegin=200841|AlignEnd=200841|Gloss=PUNCT
```

![Dependency graph for the sentence "you understand?"](./ENU_22_Barman-Interview_MG__53.svg)
