# pSUD_French-Rhapsodie

This treebank is the prosody based version of the corresponding [SUD_French-Rhapsodie](https://github.com/surfacesyntacticud/SUD_French-Rhapsodie).
It contains both the syntactic structure and the syllables encoding.

## Reference
 - Maria Paz Botero-Garcia, Emmett Strickland, Bruno Guillaume, Sylvain Kahane, and Anne Lacheret-Dujour. 2025. [An intonosyntactic treebank for spoken French: What is new with Rhapsodie?](https://aclanthology.org/2025.tlt-1.13/). In Proceedings of the 23rd International Workshop on Treebanks and Linguistic Theories (TLT, SyntaxFest 2025), pages 111–118, Ljubljana, Slovenia. Association for Computational Linguistics.

## Syllables encoding

The empty node mechanism borrowed from enhanced UD encoding is used to represent each syllable.
Special links (labelled `Syl=1`, `Syl=2`, etc) are used to encode the relationship between tokens and syllables.

Below and example of the encoding of the French sentence _ils étaient très mélomanes._ (en: _they were very fond of music._)

```
# sent_id = Rhap_D0003-7
# text = ils étaient très mélomanes.
1	ils	lui	PRON	_	Case=Nom|Emph=No|Gender=Masc|Number=Plur|Person=3|PronType=Prs	2	subj	_	AlignBegin=19411|AlignEnd=19526|Overlap=Rhap_D0003-9
1.1	_	_	_	_	_	1	Syl=1	_	AlignBegin=19411|AlignEnd=19486|AvgAmplitude=73.868|Glo=X|Loc=X|MaxAmplitude=73.868|MeanF0=0|MeanF0Step=0|Semiton=X|SemitonesFromUtteranceMean=0|Slope=X|SylForm=il
1.2	_	_	_	_	_	1|2	Syl=2|Syl=1	_	AlignBegin=19486|AlignEnd=19616|AvgAmplitude=69.684|AvgHeightGlo=M|AvgHeightLoc=M|Duration=129|Fused=Yes|Glo=mm|Loc=mm|MaxAmplitude=73.432|MeanF0=189.923|MeanF0Step=213.181|PitchRangeGlo=L|PitchRangeLoc=L|Semiton=2.908|SemitonesFromUtteranceMean=0.688|Slope=Rise|SlopeGlo=Flat|SlopeLoc=Flat|SylForm=ze
2	étaient	être	AUX	_	Mood=Ind|Number=Plur|Person=3|Tense=Imp|VerbForm=Fin	0	root	_	AlignBegin=19526|AlignEnd=19727|Overlap=Rhap_D0003-9
2.1	_	_	_	_	_	2	Syl=2	_	AlignBegin=19616|AlignEnd=19726|AvgHeightGlo=M|AvgHeightLoc=M|Duration=110|Glo=mm|Loc=mm|PitchRangeGlo=L|PitchRangeLoc=L|SlopeGlo=Flat|SlopeLoc=Flat|SylForm=tE
3	très	très	ADV	_	_	2	mod	_	AlignBegin=19727|AlignEnd=19906|Overlap=Rhap_D0003-9
3.1	_	_	_	_	_	3	Syl=1	_	AlignBegin=19726|AlignEnd=19906|AvgAmplitude=73.739|AvgHeightGlo=M|AvgHeightLoc=M|Duration=179|Glo=mm|Loc=mm|MaxAmplitude=82.164|MeanF0=195.769|MeanF0Step=219.744|PitchRangeGlo=L|PitchRangeLoc=L|Semiton=-0.757|SemitonesFromUtteranceMean=1.213|Slope=Flat|SlopeGlo=Flat|SlopeLoc=Flat|SylForm=tRE
4	mélomanes	mélomane	NOUN	_	_	2	comp:pred	_	AlignBegin=19906|AlignEnd=20502|Gender[lex]=Masc|Number[ctxt]=Plur|Overlap=Rhap_D0003-9|SpaceAfter=No
4.1	_	_	_	_	_	4	Syl=1	_	AlignBegin=19906|AlignEnd=20046|AvgAmplitude=75.159|AvgHeightGlo=M|AvgHeightLoc=M|Duration=140|Glo=mm|Loc=mm|MaxAmplitude=76.742|MeanF0=192.821|MeanF0Step=216.435|PitchRangeGlo=L|PitchRangeLoc=L|Semiton=-0.276|SemitonesFromUtteranceMean=0.95|Slope=Flat|SlopeGlo=Flat|SlopeLoc=Flat|SylForm=me
4.2	_	_	_	_	_	4	Syl=2	_	AlignBegin=20046|AlignEnd=20186|AvgAmplitude=81.84|AvgHeightGlo=H|AvgHeightLoc=H|Duration=139|Glo=mh|Loc=mh|MaxAmplitude=82.603|MeanF0=207.393|MeanF0Step=232.791|PitchRangeGlo=L|PitchRangeLoc=L|Semiton=-1.978|SemitonesFromUtteranceMean=2.212|Slope=Fall|SlopeGlo=Rise|SlopeLoc=Rise|SylForm=lO
4.3	_	_	_	_	_	4	Syl=3	_	AlignBegin=20186|AlignEnd=20436|AvgAmplitude=79.031|AvgHeightGlo=M|AvgHeightLoc=M|Duration=249|Glo=ml|Loc=ml|MaxAmplitude=79.841|MeanF0=189.9|MeanF0Step=213.156|PitchRangeGlo=L|PitchRangeLoc=L|Semiton=2.818|SemitonesFromUtteranceMean=0.686|Slope=Rise|SlopeGlo=Fall|SlopeLoc=Fall|SylForm=ma
4.4	_	_	_	_	_	4	Syl=4	_	AlignBegin=20436|AlignEnd=20583|AvgAmplitude=73.42|AvgHeightGlo=M|AvgHeightLoc=M|Duration=147|Glo=mm|Loc=mm|MaxAmplitude=75.032|MeanF0=181.897|MeanF0Step=204.172|PitchRangeGlo=L|PitchRangeLoc=L|Semiton=-0.19|SemitonesFromUtteranceMean=-0.059|Slope=Flat|SlopeGlo=Flat|SlopeLoc=Flat|SylForm=na
5	.	.	PUNCT	_	_	2	punct	_	AlignBegin=22542|AlignEnd=22542|Overlap=Rhap_D0003-8
```

![Dependency graph for the sentence "ils étaient très mélomanes."](./Rhap_D0003-7.svg)
