# **SUD_Phrygian-KUL**: SUD treebank conversion for the corpus UD_Phrygian-KUL version 2.17
This treebank was automatically generated from the UD treebank:
[UD_Phrygian-KUL](https://github.com/UniversalDependencies/UD_Phrygian-KUL/releases/tag/r2.17).

See [SUD data page](https://surfacesyntacticud.org/data/) for more details about the conversion process.

The rest of this file is a copy of the original README associated to **UD_Phrygian-KUL** and therefore refers to UD.

---
---

# Summary

UD Phrygian-KUL annotates the New Phrygian subcorpus of the ancient Phrygian language as part of a Master's thesis in linguistics at KU Leuven.


# Introduction

UD Phrygian-KUL annotates the New Phrygian subcorpus of the ancient Phrygian language. The data are comprised of epigraphic material dating ca. 1st-3rd centuries CE following the edition by Bartomeu Obrador-Cursach (2020, pp. 525-606), with additional grammatical information taken from Ligorio and Lubotsky (2018) and a notable emendation by Hämmig (2022).

In case any rights were violated, please notify the contributors so that we can resolve the issue.

Since the data are epigraphic, the inscriptions can be linked to various metadata through stable identifiers provided by [Trismegistos](https://www.trismegistos.org/tm/index.php) (cf. Depauw & Gheldof, 2014). Each identifier thus represents an inscription, augmented by a number identifying the sentence and one for the token whenever applicable. These three elements are separated by a pipe (|) and included in the MISC field. This way, there is little difficulty in finding the provenance and approximate date of every New Phrygian inscription.


# Acknowledgments

The data were annotated by Oggi Peeters as part of a Master's thesis in linguistics at KU Leuven (Peeters, 2024). Thus, it goes without saying that any errors are my own. A big thank-you goes to supervisors Alek Keersmaekers and Toon Van Hal for their guidance throughout the project, as well as to Mark Depauw for his help in acquiring the necessary textual metadata from Trismegistos.

## References

* Depauw, M., & Gheldof, T. (2014). Trismegistos. An interdisciplinary Platform for Ancient World Texts and Related Information. In Ł. Bolikowski, V. Casarosa, P. Goodale, N. Houssos, P. Manghi, J. Schirrwagen (Eds.), _Theory and Practice of Digital Libraries - TPDL 2013 Selected Workshops (Communications in Computer and Information Science 416)_, 40–52.
* Hämmig, A. E. (2022). A “new” Neo-Phrygian curse formula. In B. Obrador-Cursach & I.-X. Adiego (Eds.), _Phrygian linguistics and epigraphy: new insights_ (pp. 89-102). Universitat de Barcelona.
* Ligorio, O., & Lubotsky, A. (2018). Phrygian. In J. Klein, B. Joseph, & M. Fritz (Eds.), _Handbook of Comparative and Historical Indo-European Linguistics_, 1816-1831. De Gruyter Mouton.
* Obrador-Cursach, B. (2020). _The Phrygian Language_. Brill.
* Peeters, O. (2024). _Fragments and Formula: An annotated corpus for the Phrygian language_ (0832354_57760851) [Master's thesis, KU Leuven]. Teneo. https://repository.teneo.libis.be/delivery/DeliveryManagerServlet?dps_pid=IE21049119&


# Changelog

* 2025-11-15 v2.17
  * Implementation of ExtPos.
  * Corrections in annotation.
* 2024-11-15 v2.15
  * Initial release in Universal Dependencies.


<pre>
=== Machine-readable metadata (DO NOT REMOVE!) ================================
Data available since: UD v2.15
License: CC BY-SA 4.0
Includes text: yes
Parallel: no
Genre: nonfiction
Lemmas: manual native
UPOS: manual native
XPOS: not available
Features: manual native
Relations: manual native
Contributors: Peeters, Oggi
Contributing: here
Contact: oggi.peeters@student.kuleuven.be
===============================================================================
</pre>
