# **SUD_Cappadocian-AMGiC**: SUD treebank conversion for the corpus UD_Cappadocian-AMGiC version 2.17
This treebank was automatically generated from the UD treebank:
[UD_Cappadocian-AMGiC](https://github.com/UniversalDependencies/UD_Cappadocian-AMGiC/releases/tag/r2.17).

See [SUD data page](https://surfacesyntacticud.org/data/) for more details about the conversion process.

The rest of this file is a copy of the original README associated to **UD_Cappadocian-AMGiC** and therefore refers to UD.

---
---

# Summary

The "Asia Minor Greek in Contact" treebank (AMGiC, UD_AMGiC) is compiled from sentences entailing contact-induced morphosyntactic phenomena (CIMSP) that are a result of the contact between Greek and Turkish varieties in Anatolia and in adjacent regions. The sentences are traced in Asia Minor Greek (AMG) dialectal sources. In addition to the UD analysis, the AMGiC treebank provides information concerning the sociolinguistic context within which CIMSP arise.

# Introduction

AMGiC is a UD treebank dealing with cases of Contact-Induced Morphosyntactic Phenomena (CIMSP) in Inner Asia Minor Greek (AMG) that emerged under the influence of Turkish. Inner AMG comprises several interrelated but clearly distinct Cappadocian subdialects as well as the varieties of Silliot and Pharasiot (cf. Manolessou 2019; Cappadocian Greek (CG), Silliot and Pharasiot are in fact classified as distinct dialects, cf. Janse 2020: 203). Given however that the ISO 639-3 code we utilize for AMGiC is *cpg*, i.e. "Cappadocian Greek", we employ CG as a *pars pro toto* designation for all Inner AMG varieties.

Apart from the annotation, AMGiC offers a detailed metadata section, in which CIMSP are tagged (cf. Sampanis & Prokopidis 2021). The current version (as of v2.15) of AMGiC is the first batch of the treebank including CIMSP traced in Silliot. Future versions of AMGiC will include CG and Pharasiot as well.

# Acknowledgments

...

# References

* Janse, Mark. 2009. Greek-Turkish language contact in Asia Minor. *Études Helléniques/Hellenic Studies* 17: 37–54.
* Manolessou, Io. 2019. The historical background of the Asia Minor dialects. In Angela Ralli (ed.), *Morphology of the Asia Minor Greek dialects*, pages 20–65. Leiden: Brill.
* Sampanis , Konstantinos and Prokopis Prokopidis. 2021. Asia Minor Greek in Contact (AMGiC): Towards a dialectal Treebank comprising contact-induced grammatical changes. In *Proceedings of the 20th International Workshop on Treebanks and Linguistic Theories* (TLT, SyntaxFest 2021), pages 86–95, Sofia, Bulgaria. Association for Computational Linguistics.

# Changelog

* 2024-10-01 v2.15
  * Initial release in Universal Dependencies with 36 Silliot sentences.

<pre>
=== Machine-readable metadata (DO NOT REMOVE!) ================================
Data available since: UD v2.15
License: CC BY-SA 4.0
Includes text: yes
Parallel: no
Genre: nonfiction news
Lemmas: converted from manual
UPOS: converted from manual
XPOS: manual native
Features: converted from manual
Relations: converted from manual
Contributors: Sampanis, Konstantinos; Prokopidis, Prokopis; Akkurt, Furkan
Contributing: elsewhere
Contact: konstantinos.sampanis@yahoo.com
===============================================================================
</pre>
